/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class CustConDateTimeBeanData
implements Serializable {
    private static final String TRACE_MASKT = "XTODCBDT";
    private static final String TRACE_MASKF = "XTODCBDF";
    private static final String TRACE_MASKD = "XTODCBDD";
    private String clockChoice;
    private Calendar dateTimeNumber;
    private String[] timeZoneList;
    private String timeZoneChoice;

    public CustConDateTimeBeanData(String utcLocal, Calendar dateTime, String[] timeZones, String timeZone) {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBeanData ctor");
        this.clockChoice = utcLocal;
        this.dateTimeNumber = dateTime;
        this.timeZoneList = timeZones;
        this.timeZoneChoice = timeZone;
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBeanData ctor");
    }

    public String getClockChoice() {
        return this.clockChoice;
    }

    public Calendar getDateTimeNumber() {
        return this.dateTimeNumber;
    }

    public String[] getTimeZoneList() {
        return this.timeZoneList;
    }

    public String getTimeZoneChoice() {
        return this.timeZoneChoice;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        DateFormat df = null;
        TimeZone tz = TimeZone.getTimeZone(this.timeZoneChoice);
        sb.append("UTC/Local = " + this.clockChoice);
        df = DateFormat.getDateTimeInstance(0, 2);
        df.setTimeZone(tz);
        Trace.trace(TRACE_MASKF, "   toString: Date/Time = " + df.format(this.dateTimeNumber.getTime()));
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            df = DateFormat.getDateTimeInstance(2, 2, userContext.getLocale());
            df.setTimeZone(tz);
        }
        catch (NullContextException e) {
            df = DateFormat.getDateTimeInstance();
        }
        sb.append("; Date/Time=" + df.format(this.dateTimeNumber.getTime()));
        sb.append("; TimeZone=" + this.timeZoneChoice);
        return new String(sb);
    }
}

